 ; Ŀ
 ;   Bar - put the correct scale bar into a drawing.                       
 ;   Copyright 2000, 2007 by Rocket Software Ltd.                          
 ;   Currently there is no evidence that bears have any religious beliefs. 
 ; 
 (DEFUN C:BAR (/ ss entt pa ds barnam dsxp dsyp)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Get the bar block name and insertion point.                           
 ;   If it's a Gemini electrical drawing:                                  
 ; 
  (cond ((setq ss (ssget "X" (list (cons 2 "geielctb"))))
 ; Ŀ
 ;   Find or make the appropriate layer.                                   
 ; 
         (cond ((tblsearch "layer" "titleblock")
                (command "layer" "s" "titleblock" ""))
               ((tblsearch "layer" "tblock")
                (command "layer" "s" "tblock" ""))
               (t (command "layer" "m" "titleblock" "")))
 ; Ŀ
 ;   Get the required tb data, insert the appropriate block.               
 ; 
         (setq pa (cdr (assoc 10 (setq entt (entget (ssname ss 0))))))
         (setq ds (cdr (assoc 41 entt)))
         (setq barnam (strcat "bar" (itoa (fix ds)))))
 ; Ŀ
 ;   If it's a PanCanadian drawing:                                        
 ;   There are four identical TBs.                                         
 ; 
        ((or (setq ss (ssget "X" (list (cons 2 "T-A002A"))))
             (setq ss (ssget "X" (list (cons 2 "REPL-A1"))))
             (setq ss (ssget "X" (list (cons 2 "T2A"))))
             (setq ss (ssget "X" (list (cons 2 "PCPA1")))))
 ; Ŀ
 ;   Find or make the appropriate layer.                                   
 ; 
         (if (tblsearch "layer" "a-titleblock")
             (command "layer" "s" "a-titleblock" "")
             (command "layer" "m" "a-titleblock" ""))
 ; Ŀ
 ;   Get the required tb data, insert the appropriate block.               
 ; 
         (setq pa (cdr (assoc 10 (setq entt (entget (ssname ss 0))))))
         (setq ds (cdr (assoc 41 entt)))
         (setq barnam (strcat "bar" (itoa (fix ds))))
         (setq dsxp (+ (car pa) (* -9.59 ds)))
         (setq dsyp (+ (cadr pa) (* 0.37 ds)))
         (setq pa (list dsxp dsyp))))
 ; Ŀ
 ;   If there is an insertion point and the required block exists then     
 ;   insert the block, otherwise print an error message.                   
 ; 
  (cond ((and pa barnam (findfile (strcat barnam ".dwg")))
         (command ".insert" barnam pa 1 "" ""))
        ((and (setq ds (getvar "dimscale"))
              (setq barnam (strcat "bar" (itoa (fix ds))))
              (findfile (strcat barnam ".dwg")))
         (prompt (strcat "No known tb - using scale of " (itoa (fix ds)) "."))
         (command ".insert" barnam pause 1 "" ""))
        (barnam
         (prompt "No bar block available in that scale."))
        (t (prompt "Unable to insert a bar scale block.")))
 (princ))